$TITLE CGE3a
$OFFUPPER

*INTRODUCTION====================================================
$ONTEXT

In this file, the starting point is CGE2.

Savings and investment are introduced.
A modified SAM is presented (needed due to the addition of savings and
investment).

The line before any new feature or modification starts with "*++".
Search for "*Complete!!", as this is where your inputs are required.
Search for " *Complete!! " for some errors and omissions
Move " $ONTEXT " after completing the first " *Complete!! "
and press [SHIFT] [F9] to check the coding up to that point

Note that, in GAMS (as opposed to the mathematical statement),
the household savings rate (mps) is declared as a variable that
subsequently is fixed. (It was simply specified as a parameter in
the mathematical statement). Thus, investment remains savings-driven.
However, with this specification, it is now possible to change to making
savings investment-driven by simply
(1) fixing the variable for investment adjustment (IADJ); and
(2) flexing the savings rate (mps) for one of the households.
In this setting, variations in a household savings rate would assure
that the savings value is equal to the investment value. To see how
this can be done, search for "SAV-INV++".

Given that the model now includes a fixed variable, the GAMS default
variable count will now include an item that is not an endogenous
variable. To overrule this default, the "holdfixed" model attribute
is specified. As a result, only endogenous variables are included
in the variable count. To see this, search "HOLDFIXED" (cf. Footnote 8
in Exercise manual).

$OFFTEXT

*SETS============================================================

SETS

 AC global set (SAM accounts and other items)
   /AGR-A   agricultural activity
    NAGR-A  non-agricultural activity
    AGR-C   agricultural commodity
    NAGR-C  non-agricultural commodity
    LAB     labor
    CAP     capital
    U-HHD   urban household
    R-HHD   rural household
*++
    S-I     savings-investment
    TOTAL   total account in SAM   /

 ACNT(AC) all elements in AC except total

 A(AC)  activities
        /AGR-A, NAGR-A/

 C(AC)  commodities
        /AGR-C, NAGR-C/

 F(AC)  factors
        /LAB, CAP/

 H(AC)  households
        /U-HHD, R-HHD/
 ;

 ALIAS(AC,ACP); ALIAS(C,CP); ALIAS(F,FP);
 ACNT(AC) = YES; ACNT('TOTAL') = NO; ALIAS(ACNT,ACNTP);


*PARAMETERS======================================================

PARAMETERS

 ad(A)       efficiency parameter in the production fn for a
 alpha(F,A)  share of value-added to factor f in activity a
 beta(C,H)   share of household consumption spending on commodity c
 cpi         consumer price index
 cwts(C)     weight of commodity c in the CPI
 ica(C,A)    qnty of c as intermediate input per unit of activity a
 qfs(F)      supply of factor f
*++
 qinvbar(C)  base-year qnty of investment demand for commodity c
 shry(H,F)   share for household h in the income of factor f
 theta(A,C)  yield of output c per unit of activity a
 ;

*VARIABLES=======================================================

VARIABLES
*++
 IADJ      investment adjustment factor
*++
 MPS(H)    marginal (and average) propensity to save for household h
 P(C)      price of commodity c
 PA(A)     price of activity a
 PVA(A)    value-added (or net) price for activity a
 Q(C)      output level for commodity c
 QA(A)     level of activity a
 QF(F,A)   quantity demanded of factor f from activity a
 QH(C,H)   quantity consumed of commodity c by household h
 QINT(C,A) qnty of commodity c as intermediate input to activity a
*++
 QINV(C)   quantity of investment demand for commodity c
*++
 WALRAS    dummy variable (zero at equilibrium)
 WF(F)     average price of factor f
 YF(H,F)   income of household h from factor f
 YH(H)     income of household h
 ;

*EQUATIONS=======================================================

EQUATIONS

*PRODUCTION AND COMMODITY BLOCK++++++++
 PRODFN(A)      Cobb-Douglas production function for activity a
 FACDEM(F,A)    demand for factor f from activity a
 INTDEM(C,A)    intermediate demand for commodity c from activity a
 OUTPUTFN(C)    output of commodity c
 PADEF(A)       price for activity a
 PVADEF(A)      value-added price for activity a

*INSTITUTION BLOCK+++++++++++++++++++++
 FACTTRNS(H,F)  transfer of income from factor f to h-hold h
 HHDINC(H)      income of household h
 HHDEM(C,H)     consumption demand for household h & commodity c
*++
 INVDEM(C)      investment demand for commodity c

*SYSTEM CONSTRAINT BLOCK+++++++++++++++
 FACTEQ(F)      market equilibrium condition for factor f
 COMEQ(C)       market equilibrium condition for commodity c
*++
 SAVINV         savings-investment balance
 PNORM          price normalization
 ;


*PRODUCTION AND COMMODITY BLOCK++++++++

 PRODFN(A)..    QA(A) =E= ad(A)*PROD(F, QF(F,A)**alpha(F,A));

 FACDEM(F,A)..  WF(F)=E= alpha(F,A)*PVA(A)*QA(A) / QF(F,A);

 INTDEM(C,A)..  QINT(C,A) =E= ica(C,A)*QA(A);

 OUTPUTFN(C)..  Q(C) =E= SUM(A, theta(A,C)*QA(A));

 PADEF(A)..     PA(A) =E= SUM(C, theta(A,C)*P(C));

 PVADEF(A)..    PVA(A) =E= PA(A) - SUM(C, P(C)*ica(C,A));


*INSTITUTION BLOCK+++++++++++++++++++++
 FACTTRNS(H,F)..  YF(H,F)
                  =E= shry(H,F)*SUM(A, WF(F)*QF(F,A));

 HHDINC(H)..      YH(H) =E= SUM(F, YF(H,F));
*++
*Complete!!
*The following is how we modelled the demand for commodity c by household h
*in CGE2. Modify it to allow for the fact that households now save.

 HHDEM(C,H)..     QH(C,H) =E= beta(C,H)*YH(H)/P(C);                                     ;
*++
*Complete!!
*CGE2 had no investment so we need to introduce an equation showing how
*the demand for investment goods i8s determined
 INVDEM(C)..                                           ;


*SYSTEM CONSTRAINT BLOCK+++++++++++++++

 FACTEQ(F)..      SUM(A, QF(F,A)) =E= qfs(F);
*++
*Complete!!
*This needs to be modified to incorporate the fact that some goods
*are demanded for investment purposes
 COMEQ(C)..       Q(C) =E= SUM(H, QH(C,H)) + SUM(A, QINT(C,A));                                                      ;
*++
*Complete!!
*National accounting consistency requires that investment and savings are equal.
*Introduce this constraint, using the WALRAS dummy variable
 SAVINV..                                                               ;

 PNORM..          SUM(C, cwts(C)*P(C)) =E= cpi;


*MODEL===========================================================

MODEL

 CGE3  Model with savings-investment and wage distortions
 /ALL/
 ;

*SOCIAL ACCOUNTING MATRIX========================================
*++
*Complete!! Add savings values to the SAM
TABLE SAM(AC,ACP)  social accounting matrix

         AGR-A  NAGR-A  AGR-C  NAGR-C  LAB  CAP  U-HHD  R-HHD  S-I
AGR-A                     250
NAGR-A                            305
AGR-C       60      40                              50     75
NAGR-C      40      60                             100     50
LAB         72      80
CAP         78     125
U-HHD                                   80  120
R-HHD                                   72   83
S-I
;

PARAMETER
 tdiff(AC) column minus row total for account AC;
          SAM('TOTAL',ACNTP) = SUM(ACNT, SAM(ACNT,ACNTP));
          SAM(ACNT,'TOTAL')  = SUM(ACNTP, SAM(ACNT,ACNTP));
          tdiff(ACNT)        = SAM('TOTAL',ACNT) - SAM(ACNT,'TOTAL');

DISPLAY SAM, tdiff;


*ASSIGNMENTS FOR PARAMETERS AND VARIABLES========================

PARAMETERS
*The following parameters are used to define initial values of
*model variables.
*++
 IADJ0, MPS0(H), P0(C), PA0(A), PVA0(A), Q0(C), QA0(A), QF0(F,A),
 QH0(C,H), QINT0(C,A), QINV0(C), WF0(F), YF0(H,F), YH0(H), WALRAS0
 ;


*PRODUCTION AND COMMODITY BLOCK++++++++

 P0(C)      = 1;
 PA0(A)     = 1;
 WF0(F)     = 1;

 PVA0(A)    = SUM(F, SAM(F,A)) / (SAM(A,'TOTAL')/PA0(A));
 Q0(C)      = SAM('TOTAL',C)/P0(C);
 QA0(A)     = SAM('TOTAL',A)/PA0(A);
 QF0(F,A)   = SAM(F,A)/WF0(F);

 QINT0(C,A) = SAM(C,A)/P0(C);

 alpha(F,A) = SAM(F,A) / SUM(FP, SAM(FP,A));
 ad(A)      = QA0(A) / PROD(F, QF0(F,A)**alpha(F,A));
 ica(C,A)   = (SAM(C,A)/P0(C)) / QA0(A);
 theta(A,C) = (SAM(A,C)/P0(C)) / QA0(A);

*INSTITUTION BLOCK+++++++++++++++++++++
*++
 IADJ0      = 1;
*++
*complete!!
*How can we calculate the marginal propensity to save for each household
*from the SAM?
 MPS0(H)    = ;
 QH0(C,H)   = SAM(C,H)/P0(C);
*++
 QINV0(C)   = SAM(C,'S-I')/P0(C);
 YF0(H,F)   = SAM(H,F);
 YH0(H)     = SAM('TOTAL',H);
 beta(C,H)  = SAM(C,H)/SUM(CP, SAM(CP,H));
*++
*complete!!
*The investment expenditure on c is shown in the SAM by SAM(C,'S-I').
*How can we get the QUANTITY from this?
 qinvbar(C) = ;
 shry(H,F)  = SAM(H,F)/SAM('TOTAL',F);

*SYSTEM CONSTRAINT BLOCK+++++++++++++++

 cwts(C)    = SUM(H, SAM(C,H))/SUM((CP,H), SAM(CP,H));
 cpi        = SUM(C, cwts(C)*P0(C));
 qfs(F)     =  SAM(F,'TOTAL')/WF0(F);
 WALRAS0   = 0;

*INITIALISATION==================================================

*++
 IADJ.L      = IADJ0;
*++
 MPS.L(H)    = MPS0(H);
 P.L(C)      = P0(C);
 PA.L(A)     = PA0(A);
 PVA.L(A)    = PVA0(A);
 Q.L(C)      = Q0(C);
 QA.L(A)     = QA0(A);
 QF.L(F,A)   = QF0(F,A);
 QH.L(C,H)   = QH0(C,H);
 QINT.L(C,A) = QINT0(C,A);
*++
 QINV.L(C)   = QINV0(C);
 WF.L(F)     = WF0(F);
 YF.L(H,F)   = YF0(H,F);
 YH.L(H)     = YH0(H);
 WALRAS.L    = WALRAS0;

*DISPLAY+++++++++++++++++++++++++++++++

DISPLAY
 ad, alpha, beta, cpi, cwts, ica,qinvbar, shry, theta
*++
 IADJ.L, MPS.L, P.L, PA.L, PVA.L, Q.L, QA.L, QF.L, QH.L, QINT.L, QINV.L,
 WF.L, YF.L, YH.L, WALRAS.L ;
 ;

*SELECTING CLOSURE FOR SAVINGS-INVESTMENT BALANCE FOR A SIMPLE RUN
*LATER ON YOU WILL FIND A CLOSURE SWAPPING SIMULATION AND REPORTING ROUTINE

*Savings-driven investment
 MPS.FX(H) = MPS0(H);

*SAV-INV++
*If the ontext-offtext is removed from the following group of lines
*savings becomes investment-driven with the savings rate of the urban
*household as the adjusting variable.
*$ontext
 IADJ.FX         = IADJ0;
 MPS.LO('U-HHD') = -INF;
 MPS.UP('U-HHD') = +INF;
 MPS.L('U-HHD')  = MPS0('U-HHD');
*$offtext

*SOLVE STATEMENT FOR BASE========================================

 CGE3.HOLDFIXED = 1;

*SOLVE CGE3 USING MCP;


*REPORT SETUP AND BASE REPORT====================================

*SET AND PARAMETERS FOR REPORTS++++++++
*INCLUDES: A CLOSURE SWAPPING SIMULATION ROUTINE


SET
 SIM  simulations
     /BASE  base simulation
      CINCRIDS increase in capital stock with inv driven savings
      CINCRSDI increase in capital stock with savings driven inv
      /


PARAMETERS
*++
 switch(SIM)
 QFSCAPSIM(SIM)   supply of capital for simulation sim
 QFSREP(F,SIM)    supply of factor f for sim (check)
*++
 IADJREP(SIM)     investment adjustment factor
*++
 MPSREP(H,SIM)    marginal (and avg) propensity to save for household h
 SREP(H,SIM)      savings by households
 IREP(SIM)        investment
 PREP(C,SIM)      demander price for commodity c
 PAREP(A,SIM)     price of activity a
 PVAREP(A,SIM)    value-added price for activity a
 QREP(C,SIM)      output level for commodity c
 QAREP(A,SIM)     level of activity a
 QFREP(F,A,SIM)   demand for factor f from activity a
 QHREP(C,H,SIM)   consumption of commodity c by household h
 QINTREP(C,A,SIM) qnty of commodity c as intermed. input for activity a
*++
 QINVREP(C,SIM)   quantity of investment by commodity of origin c
 WFREP(F,SIM)     average price of factor f
 WFAREP(F,A,SIM)  price of factor f for activity a
 YFREP(H,F,SIM)   income of household h from factor f
 YHREP(H,SIM)     income of household h
*++
 WALRASREP(SIM)   dummy variable (zero at equilibrium)
 ;

 QFSCAPSIM('BASE')  = qfs('CAP');
 QFSCAPSIM('CINCRIDS') = 1.1*qfs('CAP');
 QFSCAPSIM('CINCRSDI') = 1.1*qfs('CAP');

switch(sim) = 1;
switch('CINCRIDS') = 2 ;

LOOP(SIM,

 qfs('CAP') = QFSCAPSIM(SIM);

IF(switch(sim)   = 1,
 MPS.FX(H)       = MPS0(H);
 IADJ.LO         = -INF;
 IADJ.UP         = +INF;
 IADJ.L          = IADJ0;
);

IF(switch(sim)   = 2,
 MPS.FX(H)       = MPS0(H);
 IADJ.FX         = IADJ0;
 MPS.LO('U-HHD') = -INF;
 MPS.UP('U-HHD') = +INF;
 MPS.L('U-HHD')  = MPS0('U-HHD');
);

 SOLVE CGE3 USING MCP;


 QFSREP(F,SIM)      = qfs(F);
*++
 MPSREP(H,SIM)      = MPS.L(H);
*++
 IADJREP(SIM)       = IADJ.L;
 QHREP(C,H,SIM)     = QH.L(C,H);
 QINTREP(C,A,SIM)   = QINT.L(C,A);
 QREP(C,SIM)        = Q.L(C);
 QAREP(A,SIM)       = QA.L(A);
 QFREP(F,A,SIM)     = QF.L(F,A);
 PREP(C,SIM)        = P.L(C);
 PAREP(A,SIM)       = PA.L(A);
 PVAREP(A,SIM)      = PVA.L(A);
*++
 QINVREP(C,SIM)     = QINV.L(C);
 WFREP(F,SIM)       = WF.L(F);
 YFREP(H,F,SIM)     = YF.L(H,F);
 YHREP(H,SIM)       = YH.L(H);
*++
 WALRASREP(SIM)     = WALRAS.L;
 SREP(H,SIM)        = YH.L(H)*MPS.L(H);
 IREP(SIM)          = SUM(C, P.L(C)*QINV.L(C));
);

OPTION QFREP:3:1:1, QHREP:3:1:1, WFAREP:3:1:1, YFREP:3:1:1;

DISPLAY
*++
 QFSREP, IADJREP, MPSREP, SREP, IREP, QHREP, QINVREP, QREP,
 QAREP, QFREP,PREP, PAREP, PVAREP, WFREP, YFREP, YHREP, WALRASREP
 ;

$OFFTEXT